/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.swing;

import frc.emul.config.Configuration;
import frc.emul.config.data.CfgItemJoystick;
import frc.emul.config.data.CfgItemKeymapping;
import frc.emul.util.Utils;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.Browser;
import frc.emul.vectrex.ui.config.UIUtils;
import frc.emul.version.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIWelcomePane {
    private static JDialog shared;
    public static final HyperlinkListener LINK_LISTENER;

    static {
        LINK_LISTENER = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        System.out.println("URL = [" + hyperlinkEvent.getURL().toExternalForm() + "]");
                        Browser.displayURL(hyperlinkEvent.getURL().toExternalForm(), true);
                    }
                    catch (Exception exception) {
                        System.out.println("Error while browsing " + hyperlinkEvent.getURL().toExternalForm() + ": ");
                        exception.printStackTrace(System.out);
                    }
                }
            }
        };
    }

    public static void open(JFrame jFrame, Configuration configuration) {
        try {
            UIWelcomePane.openImpl(jFrame, configuration);
        }
        catch (Exception exception) {
            System.out.println("*** Error while opening the Welcome dialog :");
            exception.printStackTrace(System.out);
        }
    }

    private static void openImpl(final JFrame jFrame, final Configuration configuration) {
        JDialog jDialog;
        JFrame jFrame2;
        boolean bl;
        if (shared != null) {
            shared.toFront();
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        UIWelcomePane.open(jFrame, configuration);
                    }
                });
                return;
            }
            catch (Exception exception) {
                throw new RuntimeException("Error while waiting for processing by EDT", exception);
            }
        }
        boolean bl2 = bl = jFrame == null;
        if (jFrame == null) {
            jFrame2 = new JFrame("Welcome to ParaJVE !");
            jFrame2.setUndecorated(true);
            jFrame2.setIconImage(UIUtils.getFrameIcon());
            jFrame2.setMinimumSize(new Dimension(1, 1));
            jFrame2.setBounds(-1, -1, 1, 1);
            jFrame2.setVisible(true);
        } else {
            jFrame2 = jFrame;
        }
        shared = jDialog = new JDialog(jFrame2, "Welcome to ParaJVE !", true);
        JButton jButton = new JButton(bl ? "Enough with this, it's time to play..." : "O K");
        UIUtils.registerEscapeButton(jButton, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (shared == jDialog) {
                    shared = null;
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        jPanel.add((Component)jButton, "Center");
        JComponent jComponent = UIWelcomePane.buildOverallComponent(configuration, bl);
        JPanel jPanel2 = (JPanel)jDialog.getContentPane();
        jPanel2.setLayout(new BorderLayout(0, 10));
        jPanel2.add((Component)jComponent, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBorder(Borders.EMPTY_10);
        jDialog.setDefaultCloseOperation(2);
        jDialog.getRootPane().setDefaultButton(jButton);
        jDialog.pack();
        jDialog.setSize(550, 633);
        UIUtils.center(jDialog, jFrame, 20, 10);
        jDialog.setVisible(true);
        if (jFrame2 != jFrame) {
            jFrame2.dispose();
        }
    }

    public static synchronized JComponent buildOverallComponent(Configuration configuration, boolean bl) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setFocusable(false);
        if (Version.isBetaVersion()) {
            jTabbedPane.addTab("<html><font color=#800000>&nbsp;<b>License</b>&nbsp;", UIWelcomePane.buildLicenseComponent());
        }
        jTabbedPane.addTab(" Welcome ", UIWelcomePane.buildWelcomeComponent(configuration, bl));
        jTabbedPane.addTab(" What's new ", UIWelcomePane.buildWhatsNewComponent());
        jTabbedPane.addTab(" History ", UIWelcomePane.buildHistoryComponent());
        jTabbedPane.addTab(" Credits ", UIWelcomePane.buildCreditsComponent());
        jTabbedPane.setSelectedIndex(Version.isBetaVersion() ? 1 : 0);
        return jTabbedPane;
    }

    public static JComponent buildLicenseComponent() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("$USR$", Version.getBetaOwner());
        return UIWelcomePane.buildHtmlComponentFromUrl("frc/emul/vectrex/swing/html/license.data", hashMap);
    }

    public static JComponent buildWelcomeComponent(Configuration configuration, boolean bl) {
        CfgItemKeymapping cfgItemKeymapping = configuration.keyMapping;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 1;
        while (n < 3) {
            CfgItemJoystick cfgItemJoystick = n == 1 ? cfgItemKeymapping.joy1 : cfgItemKeymapping.joy2;
            String string = "$J" + n;
            hashMap.put(String.valueOf(string) + "1$", cfgItemJoystick.keyBtn1.getString(true));
            hashMap.put(String.valueOf(string) + "2$", cfgItemJoystick.keyBtn2.getString(true));
            hashMap.put(String.valueOf(string) + "3$", cfgItemJoystick.keyBtn3.getString(true));
            hashMap.put(String.valueOf(string) + "4$", cfgItemJoystick.keyBtn4.getString(true));
            hashMap.put(String.valueOf(string) + "L$", cfgItemJoystick.keyLeft.getString(true));
            hashMap.put(String.valueOf(string) + "R$", cfgItemJoystick.keyRight.getString(true));
            hashMap.put(String.valueOf(string) + "U$", cfgItemJoystick.keyUp.getString(true));
            hashMap.put(String.valueOf(string) + "D$", cfgItemJoystick.keyDown.getString(true));
            ++n;
        }
        hashMap.put("$VER$", Version.sSHORT);
        hashMap.put("$1ST$", bl ? "--" : null);
        return UIWelcomePane.buildHtmlComponentFromUrl("frc/emul/vectrex/swing/html/welcome.data", hashMap);
    }

    public static JComponent buildWhatsNewComponent() {
        return UIWelcomePane.buildHtmlComponentFromUrl("frc/emul/vectrex/swing/html/whatsnew.data");
    }

    public static JComponent buildHistoryComponent() {
        return UIWelcomePane.buildHtmlComponentFromUrl("frc/emul/vectrex/swing/html/history.data");
    }

    public static JComponent buildCreditsComponent() {
        if (Version.isBetaVersion()) {
            JButton jButton = new JButton("Not implemented in beta version!");
            jButton.setEnabled(false);
            jButton.setFocusable(false);
            return jButton;
        }
        return UIWelcomePane.buildHtmlComponentFromUrl("frc/emul/vectrex/swing/html/credits.data");
    }

    public static JComponent buildHtmlComponentFromText(String string) {
        return UIWelcomePane.buildHtmlComponent(string, null);
    }

    public static JComponent buildHtmlComponentFromUrl(String string, Map<String, String> map) {
        String string2 = "<font color=red><br>&nbsp;<b>Failed to read resource</b> : " + string;
        try {
            byte[] byArray = Utils.loadResource(string);
            string2 = new String(byArray);
            if (map != null && !map.isEmpty()) {
                string2 = Utils.substitute(string2, map);
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to load HTML content from [" + string + "] :");
            exception.printStackTrace(System.out);
        }
        return UIWelcomePane.buildHtmlComponent(string2, null);
    }

    public static JComponent buildHtmlComponentFromUrl(String string) {
        URL uRL = Utils.getResourceURL(string);
        if (uRL == null) {
            return UIWelcomePane.buildHtmlComponent("<font color=red><br>&nbsp;<b>Failed to read resource</b> : " + string, null);
        }
        return UIWelcomePane.buildHtmlComponent(null, uRL);
    }

    private static JComponent buildHtmlComponent(final String string, URL uRL) {
        Serializable serializable;
        JEditorPane jEditorPane;
        try {
            if (string == null) {
                jEditorPane = new JEditorPane();
            } else {
                uRL = new URL("file:/**ParaJVE**");
                jEditorPane = new JEditorPane(){

                    protected InputStream getStream(URL uRL) throws IOException {
                        this.setContentType("text/html");
                        return new ByteArrayInputStream(string.getBytes());
                    }
                };
            }
            jEditorPane.setPage(uRL);
        }
        catch (Exception exception) {
            System.out.println("Failed to load HTML content from [" + uRL + "] :");
            exception.printStackTrace(System.out);
            jEditorPane = new JEditorPane("text/html", "<font color=red><br>&nbsp;<b>Content not available!");
        }
        jEditorPane.setEditable(false);
        jEditorPane.setBackground(Color.WHITE);
        jEditorPane.addHyperlinkListener(LINK_LISTENER);
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jEditorPane.setFont(UIManager.getFont("Label.font"));
        try {
            serializable = Utils.getResourceURL("frc/emul/vectrex/swing/html/bullet6.png");
            ((HTMLDocument)jEditorPane.getDocument()).getStyleSheet().addRule("ul {list-style-image: " + serializable + "; margin-left: 18px; }");
        }
        catch (Exception exception) {}
        serializable = new JScrollPane(jEditorPane);
        ((JComponent)serializable).setBorder(null);
        ((JComponent)serializable).setBackground(Color.WHITE);
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel.setBorder(new EmptyBorder(4, 6, 6, 6));
        jPanel.add((Component)serializable);
        jPanel.setBackground(Color.WHITE);
        return jPanel;
    }

    public static final String substitute(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return string;
        }
        if ((stringArray.length & 1) != 0) {
            throw new IllegalArgumentException("Odd number of variables arguments : " + stringArray.length);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            hashMap.put(stringArray[n], stringArray[n + 1]);
            n += 2;
        }
        return Utils.substitute(string, hashMap);
    }
}

